<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Dragonbyte Technologies Advanced Post Thanks & Like Pro 1.1.9    # ||
|| # ---------------------------------------------------------------- # ||
|| # Nulled by x iJB x                                                # ||
|| # This is a p0wersurge.com release                                 # ||
|| # ---------------------------- Greetz ---------------------------- # ||
|| # TeamPS extends their greetz to all the nullification scene,      # ||
|| # including FS and DGT. Thanks go to FS for teaching me to null    # ||
|| # properly. Thanks also go to decodeby.us (RIP) for the ionCube    # ||
|| # decoder I use for decoding certain scripts :p                    # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// ##################### DEFINE IMPORTANT CONSTANTS ######################
define('THIS_SCRIPT', 'thanks');
define('CVS_REVISION', '$RCSfile: thanks.php,v $ - $Revision: $WCREV$ $');

// ################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array('dbtech_thanks', 'cphome', 'logging', 'threadmanage', 'banning', 'cpuser', 'cpoption', 'cppermission');

// get special data templates from the datastore
$specialtemplates = array();

// ######################### REQUIRE BACK-END ############################
require_once('./global.php');

// ######################## CHECK ADMIN PERMISSIONS ######################
if (!can_administer('canadminthanks'))
{
	print_cp_no_permission();
}

// ############################# LOG ACTION ##############################
log_admin_action();

// ############################# VBPHRASE   ##############################
$vbphrase['dbtech_thanks_importer'] = 'Post Thanks v7.7 to DBTech Advanced Thanks / Like v1.x';
$vbphrase['dbtech_thanks_entries_per_page'] = 'Thanks per page';
$vbphrase['dbtech_thanks_importing_thanks'] = 'Importing Thanks';
$vbphrase['dbtech_thanks_thanks_imported'] = 'Thanks imported successfully! Please run the Recalculate function under Post Thanks - Maintenance.';

// ########################################################################
// ######################### START MAIN SCRIPT ############################
// ########################################################################

if (!empty($_POST['do']))
{
	// $_POST requests take priority
	$action = $_POST['do'];
}
else if (!empty($_GET['do']))
{
	// We had a GET request instead
	$action = $_GET['do'];
}
else
{
	// No request
	$action = 'main';
}

print_cp_header($vbphrase['dbtech_thanks_importer']);
switch ($action)
{
	case 'main':
		print_form_header('thanksimport', 'doimport');	
		print_table_header($vbphrase['dbtech_thanks_importer']);
		print_input_row($vbphrase['dbtech_thanks_entries_per_page'], 'perpage', 15);
		print_submit_row($vbphrase['submit'], 0);
		break;
		
	case 'doimport':
		$vbulletin->input->clean_array_gpc('r', array(
			'perpage' 		=> TYPE_UINT,
			'startat' 		=> TYPE_UINT
		));
	
		if (empty($vbulletin->GPC['perpage']))
		{
			$vbulletin->GPC['perpage'] = 15;
		}
		
		echo '<p>' . $vbphrase['dbtech_thanks_importing_thanks'] . '...</p>';
		
		require_once(DIR . '/includes/class_dbalter.php');
		$db_alter = new vB_Database_Alter_MySQL($db);
		
		if ($db_alter->fetch_table_info('post_thanks'))
		{
			$db_alter->add_field(array(
				'name'       => '__imported',
				'type'       => 'tinyint',
				'length'     => '1',
				'attributes' => 'unsigned',
				'null'       => false,	// True = NULL, false = NOT NULL
				'default'    => '0'
			));
		}
		
		if ($db_alter->fetch_table_info('dbtech_thanks_entry'))
		{
			// Check what thanks column we should use
			$thanks_column = ($db_alter->table_field_data['varname'] ? 'varname' : 'entrytype');
		}
		else
		{
			die('Please install Advanced Post Thanks / Like before running the importer.');
		}
		
		$thanks = $db->query_read_slave("
			SELECT *
			FROM " . TABLE_PREFIX . "post_thanks
			WHERE id >= " . $vbulletin->GPC['startat'] . "
			ORDER BY id
			LIMIT " . $vbulletin->GPC['perpage']
		);
		$finishat = $vbulletin->GPC['startat'];
		
		while ($thanksinfo = $db->fetch_array($thanks))
		{
			if ($thanksinfo['__imported'])
			{
				// Already imported
				continue;
			}
			
			$db->query_write("
				INSERT IGNORE INTO " . TABLE_PREFIX . "dbtech_thanks_entry
					($thanks_column, userid, contenttype, contentid, dateline)
				VALUES (
					'thanks',
					" . $db->sql_prepare($thanksinfo['userid']) . ",
					'post',
					" . $db->sql_prepare($thanksinfo['postid']) . ",
					" . $db->sql_prepare($thanksinfo['date']) . "
				)
			");
			
			// Now finally save
			if ($db->affected_rows())
			{
				// Success
				$db->query_write("UPDATE " . TABLE_PREFIX . "post_thanks SET __imported = 1 WHERE id = " . intval($thanksinfo['id']));
			}
			
			echo construct_phrase($vbphrase['processing_x'], $thanksinfo['id']) . "<br />\n";
			vbflush();
		
			$finishat = ($thanksinfo['id'] > $finishat ? $thanksinfo['id'] : $finishat);
		}
		
		$finishat++;
		
		if ($checkmore = $db->query_first_slave("SELECT id FROM " . TABLE_PREFIX . "post_thanks WHERE id >= $finishat LIMIT 1"))
		{
			print_cp_redirect("thanksimport.php?" . $vbulletin->session->vars['sessionurl'] . "do=doimport&startat=$finishat&pp=" . $vbulletin->GPC['perpage']);
			echo "<p><a href=\"thanksimport.php?" . $vbulletin->session->vars['sessionurl'] . "do=doimport&amp;startat=$finishat&amp;pp=" . $vbulletin->GPC['perpage'] . "\">" . $vbphrase['click_here_to_continue_processing'] . "</a></p>";
		}
		else
		{
			define('CP_REDIRECT', 'thanks.php?do=finalise&version=111');
			print_stop_message($vbphrase['dbtech_thanks_thanks_imported']);
		}

		break;
}
print_cp_footer();

/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Dragonbyte Technologies Advanced Post Thanks & Like Pro 1.1.9    # ||
|| # ---------------------------------------------------------------- # ||
|| # Nulled by x iJB x                                                # ||
|| # This is a p0wersurge.com release                                 # ||
|| # ---------------------------- Greetz ---------------------------- # ||
|| # TeamPS extends their greetz to all the nullification scene,      # ||
|| # including FS and DGT. Thanks go to FS for teaching me to null    # ||
|| # properly. Thanks also go to decodeby.us (RIP) for the ionCube    # ||
|| # decoder I use for decoding certain scripts :p                    # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/
?>